unit schoolMarks_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Generics.Collections;

type
  TfrmSchoolMarks = class(TForm)
    lbxResults: TListBox;
    lblResults: TLabel;
    btnReadCSV: TButton;
    btnQ1: TButton;
    btnQ2: TButton;
    btnQ3: TButton;
    btnQ4: TButton;
    btnQ5: TButton;
    btnQ6: TButton;
    btnQ7: TButton;
    btnQ8: TButton;
    btnQ9: TButton;
    btnQ10: TButton;
    btnQ11: TButton;
    btnQ12: TButton;
    btnQ13: TButton;
    btnQ14: TButton;
    btnQ15: TButton;
    procedure btnReadCSVClick(Sender: TObject);
    procedure btnQ1Click(Sender: TObject);
    procedure btnQ2Click(Sender: TObject);
    procedure btnQ3Click(Sender: TObject);
    procedure btnQ4Click(Sender: TObject);
    procedure btnQ5Click(Sender: TObject);
    procedure btnQ6Click(Sender: TObject);
    procedure btnQ7Click(Sender: TObject);
    procedure btnQ8Click(Sender: TObject);
    procedure btnQ9Click(Sender: TObject);
    procedure btnQ10Click(Sender: TObject);
    procedure btnQ11Click(Sender: TObject);
    procedure btnQ12Click(Sender: TObject);
    procedure btnQ13Click(Sender: TObject);
    procedure btnQ14Click(Sender: TObject);
    procedure btnQ15Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSchoolMarks: TfrmSchoolMarks;
  aData: Array [1 .. 5, 1 .. 7] of Integer;

implementation

{$R *.dfm}

procedure CSVIntoArray;
var
  sData: String;
  iComma, i, j: Integer;
  fCSV: TextFile;
  // aData : Array[1..5, 1..7] of Integer; (Global variable)

begin
  AssignFile(fCSV, 'marks.csv');
  Reset(fCSV);
  ReadLn(fCSV, sData);
  for i := 1 to 5 do
  begin
    ReadLn(fCSV, sData);
    for j := 1 to 7 do
    begin
      iComma := Pos(',', sData);
      if iComma > 0 then
      begin
        aData[i, j] := StrToInt(Copy(sData, 1, iComma - 1));
        Delete(sData, 1, iComma);
      end
      else
        aData[i, j] := StrToInt(Copy(sData, 1, Length(sData)));
    end;
  end;
end;

procedure TfrmSchoolMarks.btnQ10Click(Sender: TObject);
var
  i: Integer;
  oldest: Integer;
begin
  oldest := 0;
  for i := 1 to 5 do
  begin
    if oldest < aData[i, 2] then
      oldest := aData[i, 2];
  end;
  lbxResults.Items.Add(format('The age of the oldest student is:  %d',
      [oldest]));
end;

procedure TfrmSchoolMarks.btnQ11Click(Sender: TObject);
var
  i: Integer;
  studNumber: Integer;
  bestExamMark: Integer;
begin
  bestExamMark := 0;
  for i := 1 to 5 do
  begin
    if bestExamMark < aData[i, 7] then
    begin
      bestExamMark := aData[i, 7];
      studNumber := aData[i, 1]
    end;
  end;
  lbxResults.Items.Add(IntToStr(studNumber) + ' got the best exam mark');
end;

procedure TfrmSchoolMarks.btnQ12Click(Sender: TObject);
var
  i: Integer;
  studNumber: Integer;
  highestFees: Integer;
begin
  highestFees := 0;
  for i := 1 to 5 do
  begin
    if highestFees < aData[i, 3] then
    begin
      highestFees := aData[i, 3];
      studNumber := aData[i, 1]
    end;
  end;
  lbxResults.Items.Add(IntToStr(studNumber) + ' has highest outstanding fees');

end;

procedure TfrmSchoolMarks.btnQ13Click(Sender: TObject);
var
  i, j: Integer;
  sum: Integer;
  aveMark: Double;
  studNumber: Integer;
begin
  aveMark := 0.0;
  studNumber := 1;
  for i := 1 to 5 do
  begin
    sum := 0;
    for j := 4 to 7 do
    begin
      sum := sum + aData[i, j];
    end;
    if aveMark < (sum / 4) then
    begin
      aveMark := sum / 4;
      studNumber := aData[i, 1];
    end;
  end;
  lbxResults.Items.Add(IntToStr(studNumber) + ' has the highest average mark');
end;

procedure TfrmSchoolMarks.btnQ14Click(Sender: TObject);
var
  i, j: Integer;
  lowest: Integer;
begin
  lowest := 101;
  for i := 1 to 5 do
    for j := 4 to 7 do
    begin
      if aData[i, j] < lowest then
        lowest := aData[i, j];
    end;
  lbxResults.Items.Add(format('The lowest mark is:  %d', [lowest]));
end;

procedure TfrmSchoolMarks.btnQ15Click(Sender: TObject);
var
  j: Integer;
  lowest: Integer;
begin
  lowest := 101;
  for j := 4 to 7 do
    if aData[4, j] < lowest then
      lowest := aData[4, j];
  lbxResults.Items.Add(format('The lowest mark of 20004 is:  %d', [lowest]));
end;

procedure TfrmSchoolMarks.btnQ1Click(Sender: TObject);
var
  j: Integer;
  sum: Integer;
  aveMark: Double;
begin
  sum := 0;
  for j := 4 to 7 do
  begin
    sum := sum + aData[3, j];
  end;
  aveMark := sum / 4;
  lbxResults.Items.Add('');
  lbxResults.Items.Add(format('The average mark of 20003 is:  %.2f',
      [aveMark]));
end;

procedure TfrmSchoolMarks.btnQ2Click(Sender: TObject);
var
  j: Integer;
  highest: Integer;
begin
  highest := 0;
  for j := 4 to 7 do
  begin
    if aData[2, j] > highest then
      highest := aData[2, j];
  end;
  lbxResults.Items.Add(format('The highest mark of 20002 is:  %d', [highest]));
end;

procedure TfrmSchoolMarks.btnQ3Click(Sender: TObject);
var
  i: Integer;
  totalFees: Integer;
begin
  totalFees := 0;
  for i := 1 to 5 do
  begin
    totalFees := totalFees + aData[i, 3];
  end;
  lbxResults.Items.Add(format('Total fees outstanding is:  R%d.00',
      [totalFees]));
end;

procedure TfrmSchoolMarks.btnQ4Click(Sender: TObject);
var
  i: Integer;
  sum: Integer;
  aveAge: Double;
begin
  sum := 0;
  for i := 1 to 5 do
  begin
    sum := sum + aData[i, 2];
  end;
  aveAge := sum / 5;
  lbxResults.Items.Add(format('The average age is:  %.1f', [aveAge]));
end;

procedure TfrmSchoolMarks.btnQ5Click(Sender: TObject);
var
  i, j: Integer;
  highest: Integer;
begin
  highest := 0;
  for i := 1 to 5 do
    for j := 4 to 7 do
    begin
      if aData[i, j] > highest then
        highest := aData[i, j];
    end;
  lbxResults.Items.Add(format('The highest mark is:  %d', [highest]));
end;

procedure TfrmSchoolMarks.btnQ6Click(Sender: TObject);
var
  i, j: Integer;
  sum, count: Integer;
  aveMark: Double;
begin
  sum := 0;
  count := 0;
  for i := 1 to 5 do
    for j := 4 to 7 do
    begin
      sum := sum + aData[i, j];
      inc(count);
    end;
  aveMark := sum / count;
  lbxResults.Items.Add(format('The average mark is:  %.2f', [aveMark]));
end;

procedure TfrmSchoolMarks.btnQ7Click(Sender: TObject);
var
  j: Integer;
  lowest: Integer;
begin
  lowest := 101;
  for j := 4 to 7 do
  begin
    if aData[5, j] < lowest then
      lowest := aData[5, j];
  end;
  lbxResults.Items.Add(format('The lowest mark of 20005 is:  %d', [lowest]));
end;

procedure TfrmSchoolMarks.btnQ8Click(Sender: TObject);
var
  j: Integer;
  highest: Integer;
begin
  highest := 0;
  for j := 4 to 7 do
  begin
    if aData[4, j] > highest then
      highest := aData[4, j];
  end;
  if highest = aData[4, 6] then
    lbxResults.Items.Add('20004 obtained personal best mark for the assignment')
  else
    lbxResults.Items.Add(
      '20004 did NOT obtained personal best mark for the assignment');
end;

procedure TfrmSchoolMarks.btnQ9Click(Sender: TObject);
var
  j: Integer;
  sum: Integer;
  aveAge: Double;
begin
  sum := 0;
  for j := 4 to 7 do
  begin
    sum := sum + aData[2, j];
  end;
  aveAge := sum / 4;
  if aveAge > 90 then
    lbxResults.Items.Add('200002 obtained and average > 90%')
  else
    lbxResults.Items.Add('200002 did NOT obtained and average > 90%');
end;

procedure TfrmSchoolMarks.btnReadCSVClick(Sender: TObject);
var
  i, j: Integer;
  sOutput: String;
begin
  CSVIntoArray;
  lbxResults.Clear;
  for i := 1 to 5 do
  begin
    sOutput := '';
    for j := 1 to 7 do
    begin
      sOutput := sOutput + IntToStr(aData[i, j]) + #9;
    end;
    lbxResults.Items.Add(sOutput);
  end;
end;

end.
